#ifndef SHRENDERMAN_H__
#define SHRENDERMAN_H__

enum
{
	ID_QUALITY							= 10000,
	CINEMAN_MOTIONBLUR					= 10003,	// LONG (None, When Tagged, Always)
		CINEMAN_MOTIONBLUR_NONE			= 0,
		CINEMAN_MOTIONBLUR_TAGGED		= 1,
		CINEMAN_MOTIONBLUR_ALWAYS		= 2,
	CINEMAN_MBLURTYPE					= 10028,	// LONG (Transform Only, Transform & Deform)
		CINEMAN_MBLURTYPE_TRANSFORM		= 0,
		CINEMAN_MBLURTYPE_TRANSDEFORM	= 1,
	CINEMAN_MBLURLENGTH					= 10004,	// Real

	CINEMAN_PIXELSAMPLESX				= 10005,	// LONG
	CINEMAN_PIXELSAMPLESY				= 10006,	// LONG
	CINEMAN_SHADINGRATE					= 10008,	// Real
	CINEMAN_MOTIONFACTOR				= 10009,	// Real
	CINEMAN_PIXELFILTER					= 10010,	// LONG
		CINEMAN_PIXELFILTER_BOX			= 0,
		CINEMAN_PIXELFILTER_TRIANGLE	= 1,
		CINEMAN_PIXELFILTER_CATMULLROM	= 2,
		CINEMAN_PIXELFILTER_GAUSSIAN	= 3,
		CINEMAN_PIXELFILTER_SINC		= 4,
	CINEMAN_XFILTERWIDTH				= 10011,	// Real
	CINEMAN_YFILTERWIDTH				= 10012,	// Real
	CINEMAN_DOF							= 10020,	// Bool
	CINEMAN_FOCALDISTANCE				= 10021,	// Real
	CINEMAN_FROMCAMERA					= 10022,	// Bool
	CINEMAN_FOCALLENGTH					= 10023,	// Real
	CINEMAN_FSTOP						= 10024,	// Real
	CINEMAN_RAYSHADOWBIAS				= 10025,	// Real

	CINEMAN_FLATNESS					= 10027,	// Real

		CINEMAN_HYPERNURBS					= 10051,	// LONG
		CINEMAN_HYPERNURBS_POLYMESH		= 0,
		CINEMAN_HYPERNURBS_CATMULLCLARK = 1,

	CINEMAN_INSTANCES					= 10052,	// LONG
		CINEMAN_INSTANCES_RAWGEOMETRY	= 0,
		CINEMAN_INSTANCES_READARCHIVE	= 1,


	CINEMAN_GI_INDIRECT					= 10100,	// LONG
		CINEMAN_GI_INDIRECT_NONE		= 0,
		CINEMAN_GI_INDIRECT_INDIRECT	= 1,
		CINEMAN_GI_INDIRECT_ENVLIGHT	= 2,
	CINEMAN_GI_MAXERROR					= 10101,	// Real
	CINEMAN_GI_MAXPIXDIST				= 10102,	// Real
	CINEMAN_GI_NSAMPLES					= 10103,	// LONG
	CINEMAN_GI_MAXBOUNCE				= 10104,	// LONG
	CINEMAN_GI_PREPASS					= 10105,	// Bool
	CINEMAN_GI_PREPASSFACTOR			= 10106,	// Real
	CINEMAN_GI_ADAPTIVESAMPLING			= 10107,	// Bool
	CINEMAN_GI_MAXVARIANCE				= 10108,	// Real
	CINEMAN_GI_INTENSITY				= 10109,	// Real


	ID_ATMOSPHERE						= 20000,
	CINEMAN_ATMOSPHERE_SAMPLING			= 20020,	// LONG
		CINEMAN_ATMOSPHERE_SAMPLING_AVERAGE	= 0,
		CINEMAM_ATMOSPHERE_SAMPLING_USEMIN	= 1,
		CINEMAN_ATMOSPHERE_SAMPLING_USEMAX	= 2,
		CINEMAN_ATMOSPHERE_SAMPLING_SPECIFY	= 3,
	CINEMAN_ATMOSPHERE_STEPSIZE			= 20021,	// Real


		ID_SETTINGS							= 40000,
	CINEMAN_RENDERER					= 40001,
			CINEMAN_RENDERER_AIR		= 0,
			CINEMAN_RENDERER_PRMAN		= 1,
			CINEMAN_RENDERER_3DELIGHT	= 2,
	CINEMAN_COMMANDOPTION				= 40002,	// String
	CINEMAN_SHADERPATH					= 40010,	// String
	CINEMAN_TEXTUREPATH                 = 40011,	// String
	CINEMAN_ARCHIVEPATH					= 40012,	// String
	CINEMAN_PROCEDURALPATH				= 40013,	// String
	CINEMAN_DISPLAYPATH					= 40014,	// String

	CINEMAN_BUCKETSIZEX					= 50001,	// LONG
	CINEMAN_BUCKETSIZEY					= 50002,	// LONG
	CINEMAN_BUCKETSIZELOCK				= 50003,	// Bool
	CINEMAN_GRIDSIZE					= 50004,	// LONG (PRMan only)
	CINEMAN_TEXTUREMEMORY				= 10026,	// LONG
	CINEMAN_BRICKMEMORY					= 50005,	// LONG (PRMan only)
	CINEMAN_GEOCACHEMEMORY				= 50006,	// LONG (PRMan only)
	CINEMAN_ZTHRESHOLD					= 50007,	// Color (PRMan only)
	CINEMAN_OTHRESHOLD					= 50008,	// Color (PRMan only)
	CINEMAN_EXTREMEDISPLACEMET			= 50009,	// Bool

	ID_OUTPUT							= 30000,
	CINEMAN_DISPLAYPRESETS				= 30001,	// LONG (virtual)
		CINEMAN_DISPLAY_CUSTOM			= 0,
		CINEMAN_DISPLAY_CINEMAN			= 1,
		CINEMAN_DISPLAY_FRAMEBUFFER		= 2,
		CINEMAN_DISPLAY_FILE			= 3,
	CINEMAN_DISPLAYDRIVER				= 30002,	// String
	CINEMAN_DISPLAYNAME					= 30008,	// String
	CINEMAN_DISPLAYMODE					= 30009,	// String
	CINEMAN_QUANTIZE					= 30010,	// LONG (cycle)
		CINEMAN_QUANTIZE_CUSTOM			= 0,
		CINEMAN_QUANTIZE_8BIT			= 1,
		CINEMAN_QUANTIZE_16BIT			= 2,
		CINEMAN_QUANTIZE_16BITHEAD		= 3,
		CINEMAN_QUANTIZE_FLOAT			= 4,
	CINEMAN_QUANTIZEONE					= 30011,	// LONG
	CINEMAN_QUANTIZEMIN					= 30012,	// LONG
	CINEMAN_QUANTIZEMAX					= 30013,	// LONG
	CINEMAN_QUANTIZEDITHER				= 30014,	// Real
	CINEMAN_XRES						= 30003,	// LONG
	CINEMAN_YRES						= 30004,	// LONG
	CINEMAN_PIXELASPECT					= 30005,	// Real
	CINEMAN_FRAMEFROM					= 30006,	// BaseTime
	CINEMAN_FRAMETO						= 30007,	// BaseTime

	CINEMAN_GETFROMRENDERSETTINGS		= 30050,	// BUTTON

	CINEMAN_EXPORTSTART					= 30100,	// BUTTON
	CINEMAN_EXPORT						= 30101,	// LONG
		CINEMAN_EXPORT_SCENE			= 0,
		CINEMAN_EXPORT_OBJECTS			= 1,
		CINEMAN_EXPORT_SHADERS			= 2,
	CINEMAN_EXPORTCOMPILESHADERS		= 30102,	// Bool
	CINEMAN_EXPORTMAKETEXTURES			= 30103,	// Bool
	CINEMAN_EXPORTARCHIVES				= 30104,	// Bool
	CINEMAN_EXPORTASARCHIVE				= 30105,	// Bool
	CINEMAN_STARTRENDER					= 30107,	// Bool
	CINEMAN_ACTIVEOBJECTONLY			= 30106,	// Bool
	CINEMAN_CROPWINDOW					= 30200,	// Bool
	CINEMAN_CROPLEFT					= 30201,	// LONG
	CINEMAN_CROPRIGHT					= 30202,	// LONG
	CINEMAN_CROPTOP						= 30203,	// LONG
	CINEMAN_CROPBOTTOM					= 30204,	// LONG

	//CINEMAN_DISPLAYNAME					= 50000,
	//CINEMAN_DISPLAYPRESET				= 50001,
	//CINEMAN_DISPLAYDRIVER				= 50002,
	//CINEMAN_DISPLAYMODE					= 50003,
	CINEMAN_COLQUANTIZEONE				= 50005,	// LONG
	CINEMAN_COLQUALTIZEMIN				= 50006,	// LONG
	CINEMAN_COLQUANTIZEMAX				= 50007,
	CINEMAN_COLQUANTIZEDITHER			= 50008,

	CINEMAN_DISPLAYADD_ADD				= 59900,	// BUTTON
	CINEMAN_DISPLAYADD_COUNT			= 59901,	// LONG
	CINEMAN_DISPLAYADD					= 60000,
		CINEMAN_DISPLAYADD_NAME_OFFSET	= 0,		// STRING
		CINEMAN_DISPLAYADD_DRIVER_OFFSET= 1,		// STRING
		CINEMAN_DISPLAYADD_MODE_OFFSET	= 2,		// STRING
		//CINEMAN_DISPLAYADD_QUANTZERO	= 3,		// LONG
		CINEMAN_DISPLAYADD_QUANTONE		= 4,		// LONG
		CINEMAN_DISPLAYADD_QUANTMIN		= 5,		// LONG
		CINEMAN_DISPLAYADD_QUANTMAX		= 6,		// LONG
		CINEMAN_DISPLAYADD_REMOVE_OFFSET= 7,		// BUTTON
		CINEMAN_DISPLAYADD_OFFSET		= 100

};

#endif	// SHRENDERMAN_H__
